<?php
$con = mysqli_connect("127.0.0.1","root","","ldp_db");
if (mysqli_connect_errno()) {
    echo "Failed to connect to MySQL: " . mysqli_connect_error();
}

require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/flash.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>LDP</title>
<link rel="icon" type="image/png" href="/ldp/public/assets/img/logo.png">
<meta name="viewport" content="width=device-width, initial-scale=1">
<!-- Bootstrap / FontAwesome / AdminLTE -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.2.0/css/adminlte.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css">

<style>
.data-actions a { margin-right: .35rem; }
.form-required:after { content:" *"; color:#dc3545; }

@media print {
    /* Hide buttons, inputs, and controls */
    .btn, #part2, .alert, .ml-2, .input-group, .input-group-append, .nav-sidebar, .main-header, .main-sidebar {
        display: none !important;
    }

    /* Ensure wrappers don't block print */
    body, .wrapper, .content-wrapper, .card, .card-body {
        background: #fff !important;
        color: #000 !important;
        box-shadow: none !important;
        overflow: visible !important;
        position: static !important;
        width: 100% !important;
    }

    /* Make table fully visible */
    .table-responsive {
        overflow: visible !important;
        display: block !important;
        width: 100% !important;
    }

    table, th, td {
        border: 1px solid #000 !important;
        -webkit-print-color-adjust: exact;
        color-adjust: exact;
    }

    /* Remove shadows/borders from card headers */
    .card {
        border: none !important;
    }

    /* Expand images if needed */
    img {
        max-width: 100% !important;
        height: auto !important;
    }
}



</style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

<!-- Navbar -->
<nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <ul class="navbar-nav">
      <li class="nav-item"><a class="nav-link" data-widget="pushmenu" href="#"><i class="fas fa-bars"></i></a></li>
    </ul>
    <ul class="navbar-nav ml-auto">
      <li class="nav-item d-none d-sm-inline-block mr-3">
        <span class="text-muted">Signed in as <strong><?= htmlspecialchars($user['name'] ?? 'Guest') ?></strong> (<?= htmlspecialchars($user['role'] ?? '-') ?>)</span>
      </li>
      <li class="nav-item"><a href="/ldp/public/logout.php" class="btn btn-outline-danger btn-sm">Logout</a></li>
    </ul>
</nav>

<!-- Sidebar -->
<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <a href="/ldp/public/dashboard.php" class="brand-link">
      <img src="/ldp/public/assets/img/logo.png" alt="Logo" class="brand-image img-circle elevation-3" style="opacity:.9">
      <span class="brand-text font-weight-light">DEBESMSCAT LDP</span>
    </a>
    <div class="sidebar">
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview">
          <li class="nav-item"><a href="/ldp/public/dashboard.php" class="nav-link <?= $active==='dashboard'?'active':'' ?>"><i class="nav-icon fas fa-tachometer-alt"></i><p>Dashboard</p></a></li>
          <li class="nav-item has-treeview <?= $active==='personnel'?'menu-open':'' ?>">
            <a href="#" class="nav-link <?= $active==='personnel'?'active':'' ?>"><i class="nav-icon fas fa-id-badge"></i><p>Personnel Records<i class="right fas fa-angle-left"></i></p></a>
            <ul class="nav nav-treeview">
              <li class="nav-item"><a href="/ldp/public/personnel/create.php" class="nav-link <?= $subactive==='add'?'active':'' ?>"><i class="far fa-circle nav-icon"></i><p>Add Employee</p></a></li>
              <li class="nav-item"><a href="/ldp/public/personnel/index.php" class="nav-link <?= $subactive==='list'?'active':'' ?>"><i class="far fa-circle nav-icon"></i><p>Employee List</p></a></li>
            </ul>
          </li>
          <li class="nav-item"><a href="/ldp/public/trainings/index.php" class="nav-link <?= $active==='trainings'?'active':'' ?>"><i class="nav-icon fas fa-chalkboard-teacher"></i><p>Add Trainings</p></a></li>
          <li class="nav-item"><a href="/ldp/public/reportstrainings/index.php" class="nav-link <?= $active==='trainings'?'active':'' ?>"><i class="nav-icon fas fa-chalkboard-teacher"></i><p>Training Reports</p></a></li>
          <li class="nav-item"><a href="/ldp/public/reports/personnel.php" class="nav-link <?= $active==='reports'?'active':'' ?>"><i class="nav-icon fas fa-chart-bar"></i><p>Personnel Reports</p></a></li>
        </ul>
      </nav>
    </div>
</aside>

<!-- Content Wrapper -->
<div class="content-wrapper">
<section class="content-header">
  <div class="container-fluid">
    <h1 class="mb-2"></h1>
  </div>

  <div class="card-body p-0">
    <div class="table-responsive">

      <!-- Buttons -->
      <div class="ml-2 mb-2" id="part2">
          <button class="btn btn-sm btn-danger" id="btn-export-pdf"><i class="fas fa-file-pdf"></i> Export PDF</button>
      </div>
      <a class="btn btn-success btn-print mb-2" href="#" onclick="printDiv('pdf-content')">
    <i class="glyphicon glyphicon-print"></i> Print
</a>

      <!-- Report Table -->
      <div class="card">
        <div class="card-body p-0">
          <div class="table-responsive" id="pdf-content">
            <!-- Report Header -->
            <table class="header" style="width:100%; margin-bottom:10px;">
              <tr>
                <td><img src="http://localhost/ldp/public/assets/img/logo.png" alt="Logo" style="width:90px;height:90px;border-radius:50%;"></td>
                <td style="width:70%;">
                  Republic of the Philippines<br>
                  <strong>DR. EMILIO B. ESPINOSA SR., MEMORIAL STATE COLLEGE OF AGRICULTURE AND TECHNOLOGY</strong><br>
                  Cabitan, Mandaon, Masbate | <a href="http://www.debesmscat.edu.ph">www.debesmscat.edu.ph</a><br>
                  <strong style="font-size:23px;">TRAINING REPORTS</strong>
                </td>
                <td style="width:15%;"><img src="http://localhost/ldp/public/assets/img/l.png" alt="Logo" style="width:90px;height:90px;"></td>
              </tr>
            </table>

            <!-- Training Table -->
            <table id="table1" class="table table-striped mb-0">
              <thead>
                <tr>
                  <th>Trainee Name</th>
                  <th>Training Title of L&D</th>
                  <th>Training Description</th>
                  <th>Category</th>
                  <th>Type of L&D</th>
                  <th>Training Schedule From</th>
                  <th>Training Schedule Date</th>
                </tr>
              </thead>
              <tbody>
              <?php
              $query12 = mysqli_query($con, "SELECT * FROM training") or die(mysqli_error($con));
              while($row12 = mysqli_fetch_array($query12)) {
                  $traineeid = $row12['traineename'];
                  $query10 = mysqli_query($con, "SELECT * FROM personnel WHERE id='$traineeid'");
                  $row10 = mysqli_fetch_array($query10);
              ?>
                <tr>
                  <td><?= htmlspecialchars($row10['name']) ?></td>
                  <td><?= htmlspecialchars($row12['title'] ?? '') ?></td>
                  <td><?= htmlspecialchars($row12['description'] ?? '') ?></td>
                  <td><?= !empty($row12['leveloftraining']) ? '<span class="badge badge-info">' . htmlspecialchars($row12['leveloftraining']) . '</span>' : '' ?></td>
                  <td><?= htmlspecialchars($row12['lnd'] ?? '') ?></td>
                  <td><?= htmlspecialchars($row12['date_from'] ?? '') ?></td>
                  <td><?= htmlspecialchars($row12['created_at'] ?? '') ?></td>
                </tr>
              <?php } ?>
              </tbody>
            </table>

          </div>
        </div>
      </div>

    </div>
  </div>
</section>
</div>

<!-- JS Libraries -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/admin-lte/3.2.0/js/adminlte.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>

<!-- PDF Libraries -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://html2canvas.hertzen.com/dist/html2canvas.min.js"></script>

<!-- Initialize DataTables -->
<script>
$(document).ready(function() {
    $('#table1').DataTable({
        "paging": true,
        "searching": true,
        "info": false
    });
});
</script>
<!-- Initialize DataTables -->
<script>

// PDF Export
document.getElementById('btn-export-pdf').addEventListener('click', function () {
    const { jsPDF } = window.jspdf;
    const element = document.getElementById('pdf-content');

    html2canvas(element, { scale: 2 }).then((canvas) => {
        const imgData = canvas.toDataURL('image/png');
        const pdf = new jsPDF('p', 'mm', 'a4');
        const imgProps = pdf.getImageProperties(imgData);
        const pdfWidth = pdf.internal.pageSize.getWidth();
        const pdfHeight = (imgProps.height * pdfWidth) / imgProps.width;
        pdf.addImage(imgData, 'PNG', 0, 0, pdfWidth, pdfHeight);
        pdf.save('training_report.pdf');
    });
});




</script>

<script>
function printDiv(divId) {
    const printContents = document.getElementById(divId).innerHTML;
    const originalContents = document.body.innerHTML;

    // Replace body with printable content
    document.body.innerHTML = printContents;

    window.print();

    // Restore original page
    document.body.innerHTML = originalContents;
    location.reload(); // reload to restore JS & CSS
}
</script>


</body>
</html>
